
 
; Fridge Alarm

;	ERRORLEVEL -302
;	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_ON & _INTRC_OSC_NOCLKOUT	

; RAM 

STORE1				equ	H'20'	; delay counter	
STORE2				equ	H'21'	; delay counter
STORE3				equ	H'22'	; delay counter
FLASH				equ	H'23'	; LED flash
CHECK_COUNT		equ	H'24'	; counter for LDR checking
SOFT_START		equ	H'25'	; soft start timer
SOFT_STORE		equ	H'26'	; store soft start
SOFT_END			equ	H'27'	; subtraction value
ALM_TYPE			equ	H'28'	; alarm type
EXTN				equ	H'29'	; delay extension
REPEAT			equ	H'2A' 	; Alarm tone burst repeat
WARBLE			equ	H'2B'	; warbling flags
				
; random number generator registers
BARGB0			equ	H'31'	; random number generator
BARGB1			equ	H'32'	; random number generator
BARGB2			equ	H'33'	; random number generator
AARGB0			equ	H'34'	; random number gen
AARGB1			equ	H'35'	; random number gen
AARGB2			equ	H'36'	; random number gen
AARGB3			equ	H'37'	; random number gen
AARGB4			equ	H'38'	; random number gen
AARGB5			equ	H'39'	; random number gen
AARGB6			equ	H'3A'	; random number gen
RANDB0			equ	H'3B'	; random number seed
RANDB1			equ	H'3C'	; random number seed
RANDB2			equ	H'3D'	; random number seed
RANDB3			equ	H'3E'	; random number seed
TEMPB0			equ	H'3F'	; random gen temp files
TEMPB1			equ	H'40'	; random gen temp files
TEMPB2			equ	H'41'	; random gen temp files
TEMPB3			equ	H'42'	; random gen temp files
LOOPCOUNT		equ	H'43'	; loop counter in random gen



; start at memory 0

	org		0			; reset vector
	goto	MAIN
	    			; interrupt vector (not used)
	
; **********************************************************
	
; Lookup tables for cricket chirp

GAP					; gap between individual bursts
	addwf	PCL,f		; add w to program counter (8max)
	retlw	D'45'
	retlw	D'40'		; 40= 18ms
	retlw	D'41'
	retlw	D'40'
	retlw	D'41'
	retlw	D'39'
	retlw	D'38'
	retlw	D'41'
	retlw	D'40'
	
BURST					; individual burst length within triplet
	addwf	PCL,f		; add w to program counter (16max)
	retlw	D'71'		; 70 = 20ms
	retlw	D'70'
	retlw	D'71'
	retlw	D'70'
	retlw	D'71'
	retlw	D'70'
	retlw	D'73'
	retlw	D'71'
	retlw	D'71'
	retlw	D'70'
	retlw	D'72'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'

SEPARATION			; separation between the triple burst
	addwf	PCL,f		; add w to program counter (32max)
	retlw	D'75'	
	retlw	D'71'	; 80 = 320ms
	retlw	D'70'
	retlw	D'72'
	retlw	D'77'
	retlw	D'75'	
	retlw	D'100'	
	retlw	D'80'
	retlw	D'100'
	retlw	D'76'
	retlw	D'77'
	retlw	D'75'
	retlw	D'72'	
	retlw	D'75'
	retlw	D'78'
	retlw	D'75'
	retlw	D'77'
	retlw	D'50'
	retlw	D'60'
	retlw	D'41'
	retlw	D'65'
	retlw	D'71'
	retlw	D'75'
	retlw	D'72'
	retlw	D'73'
	retlw	D'75'	
	retlw	D'70'
	retlw	D'76'
	retlw	D'77'
	retlw	D'76'	
	retlw	D'75'
	retlw	D'70'
	retlw	D'75'

; ***********************************************************
		
MAIN
; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
	call		H'3FF'	 		; oscillator calibration value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

; delay to allow device verify after programming
; start up delay ~3s
	movlw	D'20'		; delay extension
	movwf 	STORE3
DEL_CONT
	clrwdt
	movlw	H'FF'		; delay routine
	call		DELAYX
	decfsz	STORE3,f	; when 0, exit delay
	goto	DEL_CONT

; set inputs/outputs
	clrf		GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0; select memory bank 1
	movlw	B'00010000'	; pullups off except GP4 
	movwf	WPU
	movlw	B'00001001'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00001111'	; settings (pullups enabled) wdt prescaler/128 (18ms x 128 timeout)
	movwf	OPTION_REG
	movlw	B'00010001'	; AN0 A/D Tosc/8
	movwf	ANSEL		; digital I/O
	bcf		STATUS,RP0; select memory bank 0

; analog inputs, A/D

	movlw	B'00000000'	; channel0 left justified, VDD ref etc
	movwf	ADCON0
; A/D switched on in subrotine when required	ie  set ADCON0,ADON	; A/D on

; initial conditions
	clrf		GPIO
; set initial seed value
	movlw	0x27			; random seed value
	movwf	RANDB0
	movlw	0xF1
	movwf	RANDB1
	movlw	0x20			; random seed value
	movwf	RANDB2
	movlw	0x49
	movwf	RANDB3
	call		RAND32			; random number generator


; flash LED as a power up acknowledgement
	call		ACKNOWLEDGE


; check LDR for light/darkness
CK_LDR
	bcf		GPIO,1			; switch on LDR divider
	nop
	nop
	nop						; settling time
	btfss	GPIO,3
	goto	ALARM_S		; when GPIO is low then in light

STOP

	bsf		GPIO,1			; LDR off

; SLEEP, low power mode

	sleep					; stop operations
	nop
; awakes with watchdog timeout

	goto	CK_LDR			; check LDR level
	
; ________________________________________
; check LDR
CHECK_LDR

	bcf		GPIO,1			; switch on LDR divider
	nop
	nop
	nop						; settling time
; add hysteresis
	bsf		GPIO,1			; LDR off. set high to set LDR input higher, then test again for a low
	bcf		GPIO,1			; LDR on
	nop
	nop
	btfsc	GPIO,3	
	retlw	H'FF'			; when FF goto	STOP ; when GPIO is low then light
	bsf		GPIO,1			; LDR divider off
	retlw	H'00'			; continue
; ________________________________________________

ALARM_S
	
	bsf		GPIO,1			; LDR off

; flash LEDs
	call		ACKNOWLEDGE		; flash low light detected acknowledgement
; timer extension
	movlw	D'6'              
	movwf	EXTN

; For VR1
	call		ACQUIRE_AD
LOOP_EXTN
	movf	ADRESH,w		; look at value 

; start up delay ~2 -180s

	movwf 	STORE3			; delay extension
	movlw	D'1'				; minimum of 1
	btfsc	STATUS,Z
	movwf 	STORE3	
	movlw	D'200' 
	movwf	CHECK_COUNT		; counter to check LDR
	
DEL_CONT1
	clrwdt
	movf	CHECK_COUNT,w
	btfsc	STATUS,Z
	goto	LDR_CK0
	decf	CHECK_COUNT,f
	goto	LDR_CK
LDR_CK0

	movlw	D'200' 
	movwf	CHECK_COUNT		; counter to check LDR
LDR_CK
; check LDR
	call		CHECK_LDR
	xorlw	H'FF'				; when = FF goto STOP
	btfsc	STATUS,Z
	goto	STOP

DELAY_CONT
	movlw	H'FF'			; delay routine
	call		DELAYX
	decfsz	STORE3,f		; when 0, exit delay
	goto	DEL_CONT1

; check LDR
	call		CHECK_LDR
	xorlw	H'FF'				; when FF goto STOP
	btfsc	STATUS,Z
	goto	STOP

	decfsz	EXTN,f
	goto	LOOP_EXTN

; Sound alarm

	clrf		ALM_TYPE		; alarm selection
; check alarm type (GPIO4 set as low output normally to conserve power if JP1 is in and conducting pullup current when an input)
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00011001'		; outputs/inputs set (change port 4 to an input)
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
	btfsc	GPIO,4
	bsf		ALM_TYPE,0		; set when bit 4 is set (standard alarm) (Cricket when clear)
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001001'		; outputs/inputs set (change port 4 to an output)
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0

	btfss	ALM_TYPE,0		; when clear cricket
	goto	CRICKET

SND ; (Standard alarm)
	movlw	D'3'
	movwf	WARBLE		; for changing modulation
	movlw	D'20'
	movwf	REPEAT
BURST1
	movlw	D'7'				; burst
	movwf	STORE2			; individual burst length
	call		GENERATOR_S	; 4kHz tone (uses STORE1)
	movlw	D'10'			;  
	movwf	STORE3
OFF_DEL

; warble from 400Hz to 600Hz
	movf	WARBLE,w
	xorlw	D'13'	; start again at 13
	btfss	STATUS,Z
	goto	OK
	movlw	D'12'
	movwf	WARBLE

OK	movf	WARBLE,w
	incf		WARBLE,f	; next value
	call		DELY
	decfsz	STORE3,f
	goto	OFF_DEL
	decfsz	REPEAT,f
	goto 	BURST1

; Burst Gap
	movlw	D'7'			;  
	movwf	STORE3
GAP2
	movlw	D'70' 
	call		DELAYX
	decfsz	STORE3,f
	goto	GAP2
	
; check LDR
	call		CHECK_LDR
	xorlw	H'FF'			; when FF goto STOP
	btfsc	STATUS,Z
	goto	STOP
	goto	SND

CRICKET

; Cricket
	clrwdt
	bsf		GPIO,1		; LDR off
	movlw	D'3'			; burst triplet 
	movwf	STORE3		; 3 x 4kHz bursts per chirp
CHIRP

	movf	AARGB0,w		; random value
	andlw	B'00001111'		; 16 max
	call		BURST			; get burst length
	movwf	STORE2			; individual burst length
	call		GENERATOR	; 4kHz tone (uses STORE1)

CHIRP_GAP
	call		RAND32			; random number
	movf	AARGB1,w		; random value
	andlw	B'00000111'		; 8 max
	call		GAP	
	call		DELAYX

	decfsz	STORE3,f		; run 3 bursts
	goto	CHIRP

; check LDR
	call		CHECK_LDR
	xorlw	H'FF'			; when FF goto STOP
	btfsc	STATUS,Z
	goto	STOP

TONE_GAP

; initial tone gap multiplier to give spacing between the triplets 
	movlw	D'12'
	movwf	STORE3

TONE_GAP1
	call		RAND32			; random number
	movf	AARGB2,w
	andlw	B'00011111'		; max of 32
	call		SEPARATION			
 	call		DELAYX			; delay set by separation value
	decfsz	STORE3,f
	goto	TONE_GAP1
	goto	CRICKET

; *********************************************
; subroutines

; flash LED as acknowledgement
ACKNOWLEDGE
	movlw	D'50'
	movwf	FLASH
ACK
	bcf		GPIO,1			; LED1 on
	call		DELAY_FLASH
	bsf		GPIO,1			; LED1 off
	call		DELAY_FLASH
	bcf		GPIO,1
	decfsz	FLASH,f
	goto	ACK
	bsf		GPIO,1			; LDR off
	return

; 4kHz generator (set STORE2 before routine for burst length)	
GENERATOR

; divide burst length by 4
	bcf		STATUS,C
	rrf		STORE2,w		; /2
	movwf	SOFT_START		; soft start timer
	bcf		STATUS,C
	rrf		SOFT_START,f	; /4
	bcf		STATUS,C
	rrf		SOFT_START,f	; /8
	movf	SOFT_START,w
	movwf	SOFT_STORE
	subwf	STORE2,w
	movwf	SOFT_END		; soft end timer
	goto	GENERATOR1
GENERATOR2
	bsf		GPIO,2
	bcf		GPIO,5
	clrwdt
	movlw	D'40'			; frequency value 
	movwf	STORE1
DEC1
	decfsz	STORE1,f
	goto	DEC1	
	bcf		GPIO,2
	bsf		GPIO,5
	clrwdt
	movlw	D'40'			;  frequency value
	movwf	STORE1
DEC2
	decfsz	STORE1,f
	goto	DEC2
	decfsz	SOFT_END,f		; 4kHz burst length
	goto	GENERATOR2
	movf	SOFT_STORE,w
	movwf	SOFT_START
	goto	GENERATOR3

GENERATOR1
	bsf		GPIO,2
	clrwdt
	movlw	D'60'			; frequency value 
	movwf	STORE1
DEC5
	decfsz	STORE1,f
	goto	DEC5	
	bcf		GPIO,2
	clrwdt
	movlw	D'60'			;  frequency value
	movwf	STORE1
DEC6
	decfsz	STORE1,f
	goto	DEC6
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR1		; softer burst at half drive
	goto	GENERATOR2		; full burst drive

GENERATOR3
	bsf		GPIO,2
	clrwdt
	movlw	D'60'			; frequency value 
	movwf	STORE1
DEC3
	decfsz	STORE1,f
	goto	DEC3	
	bcf		GPIO,2
	clrwdt
	movlw	D'60'			;  frequency value
	movwf	STORE1
DEC4
	decfsz	STORE1,f
	goto	DEC4
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR3	; softer burst at half drive
	return

; 4kHz generator (set STORE2 before routine for burst length)	
GENERATOR_S

	bsf		GPIO,2
	bcf		GPIO,5
	clrwdt
	movlw	D'40'			; frequency value 
	movwf	STORE1
DEC1_S
	decfsz	STORE1,f
	goto	DEC1_S	
	bcf		GPIO,2
	bsf		GPIO,5
	clrwdt
	movlw	D'40'			;  frequency value
	movwf	STORE1
DEC2_S
	decfsz	STORE1,f
	goto	DEC2_S
	decfsz	STORE2,f		; 4kHz burst length
	goto	GENERATOR_S
	return


; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	D'117'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	clrwdt
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAY_FLASH
	movlw	D'10'		; delay value
	movwf	STORE1		; STORE1 is number of loops value
LOOP10	
	movlw	D'11'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP11
	clrwdt
	decfsz	STORE2,f
	goto	LOOP11
	decfsz	STORE1,f
	goto	LOOP10
	return


DELY
	movwf	STORE1		; STORE1 is number of loops value
LOOP12	
	movlw	D'1'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP13
	clrwdt
	decfsz	STORE2,f
	goto	LOOP13
	decfsz	STORE1,f
	goto	LOOP12
	return

; Subroutines

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,ADON		; A/D on
	bcf		GPIO,1				; VR1 on
; wait ~20us. using nops ok as plenty of program memory
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	bcf		ADCON0,ADON		; A/D off
	bsf		GPIO,1				; VR1 off
	return


; Random number generator

;	Input:	32 bit initial integer seed in AARGB0, AARGB1, AARGB2, AARGB3

;	Use:	CALL	RAND32

;	Output:	32 bit random integer in AARGB0, AARGB1, AARGB2, AARGB3

;	Result:	AARG  <--  RAND32( AARG )

;	

;		min	max	mean
;	Timing:	487	487	487	clks



;	Linear congruential random number generator

;		X <- (a * X + c) mod m

;	The calculation is performed exactly, with multiplier a, increment c, and
;	modulus m, selected to achieve high ratings from standard spectral tests.
RANDOM
		clrwdt
RAND32
		MOVF		RANDB0,W
		MOVWF		AARGB0
		MOVF		RANDB1,W
		MOVWF		AARGB1
		MOVF		RANDB2,W
		MOVWF		AARGB2
		MOVF		RANDB3,W
		MOVWF		AARGB3

		MOVLW		H'0D'			; multiplier a = 1664525
		MOVWF		BARGB2
		MOVLW		H'66'
		MOVWF		BARGB1
		MOVLW		H'19'
		MOVWF		BARGB0

		CALL		FXM3224U

       		INCF       	 AARGB6,F		; c = 1
        	BTFSC    	 STATUS,Z
        	INCF       	 AARGB5,F
		BTFSC		STATUS,Z
		INCF		AARGB4,F
		BTFSC		STATUS,Z
		INCF		AARGB3,F
		BTFSC       	STATUS,Z
        	INCF        	AARGB2,F
		BTFSC		STATUS,Z
		INCF		AARGB1,F
		BTFSC		STATUS,Z
		INCF		AARGB0,F

		MOVF		AARGB3,W
		MOVWF		RANDB0			; m = 2**32
		MOVF		AARGB4,W
		MOVWF		RANDB1
		MOVF		AARGB5,W
		MOVWF		RANDB2
		MOVF		AARGB6,W
		MOVWF		RANDB3

		RETLW		0x00

;       32x24 Bit Unsigned Fixed Point Multiply 32x24 -> 56

;       Input:  32 bit unsigned fixed point multiplicand in AARGB0, AARGB1,
;               AARGB2, AARGB3

;               24 bit unsigned fixed point multiplier in BARGB0, BARGB1,
;               BARGB2

;       Use:    CALL    FXM3224U

;       Output: 56 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     11+617+2 = 630 clks

;       Min Timing:     11+151 = 162 clks

;       PM: 11+139+1 = 151              DM: 15

FXM3224U
		clrwdt
                CLRF    AARGB4          ; clear partial product
                CLRF    AARGB5
                CLRF    AARGB6
                MOVF  	AARGB0,W
                MOVWF   TEMPB0
                MOVF   	AARGB1,W
                MOVWF   TEMPB1
                MOVF   	AARGB2,W
                MOVWF   TEMPB2
                MOVF   	AARGB3,W
                MOVWF   TEMPB3

                CALL 	UMUL3224L

                RETLW           0x00

; UMUL3224L        macro

;       Max Timing:     2+15+6*25+24+2+7*26+25+2+7*27+26 = 617 clks

;       Min Timing:     2+7*6+5+1+7*6+5+1+7*6+5+6 = 151 clks

;       PM: 31+24+2+25+2+26+2+27 = 139            DM: 15

UMUL3224L
		clrwdt  
		MOVLW   0x08
                MOVWF   LOOPCOUNT

LOOPUM3224A
                RRF     BARGB2,F
                BTFSC   STATUS,C
                GOTO    ALUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224A

                MOVWF   LOOPCOUNT

LOOPUM3224B
                RRF     BARGB1,F
                BTFSC   STATUS,C
                GOTO    BLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224B

                MOVWF   LOOPCOUNT

LOOPUM3224C
                RRF     BARGB0,F
                BTFSC   STATUS,C
                GOTO    CLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224C

                CLRF    AARGB0
                CLRF    AARGB1
                CLRF    AARGB2
                CLRF    AARGB3
                RETLW   0x00
                
ALUM3224NAP
		 BCF     STATUS,C
                GOTO    ALUM3224NA
                
BLUM3224NAP    
		 BCF     STATUS,C
                GOTO    BLUM3224NA
                
CLUM3224NAP 
		 BCF     STATUS,C
                GOTO    CLUM3224NA

ALOOPUM3224
                RRF     BARGB2,F
                BTFSS   STATUS,C
                GOTO    ALUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

ALUM3224NA
                RRF     AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                DECFSZ  LOOPCOUNT,F
                GOTO    ALOOPUM3224

                MOVLW   0x08
                MOVWF   LOOPCOUNT

BLOOPUM3224
                RRF     BARGB1,F
                BTFSS   STATUS,C
                GOTO    BLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

BLUM3224NA
                RRF    	AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                RRF     AARGB5,F
                DECFSZ  LOOPCOUNT,F
                GOTO    BLOOPUM3224

                MOVLW   0x08
                MOVWF   LOOPCOUNT

CLOOPUM3224
                RRF     BARGB0,F
                BTFSS   STATUS,C
                GOTO    CLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

CLUM3224NA
                RRF     AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                RRF     AARGB5,F
                RRF     AARGB6,F
                DECFSZ  LOOPCOUNT,F
                GOTO    CLOOPUM3224
		RETURN	
                

	end
